// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "vertexVersionSimple.h"

#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"

attribute mediump vec4 POSITION;
attribute vec4 COLOR;

varying vec4 color;

const float fogNear = 0.9;

const vec3 inverseLightDirection = vec3(0.62, 0.78, 0.0);
const float ambient = 0.7;

void main()
{
    POS4 pos = WORLDVIEWPROJ * POSITION;
	POS4 worldPos = WORLD * POSITION;
 	gl_Position = pos;

   vec4 dayColor = vec4( 0.50, 0.50, 0.50, CURRENT_COLOR.a*1.5);
   vec4 nightColor = CURRENT_COLOR + vec4(0.00, 0.20, 0.75, CURRENT_COLOR.a*1.0);
 	  color = mix(nightColor * dayColor, FOG_COLOR*2.80, COLOR.r*0.30); 	

 	float depth = length(worldPos.xyz*0.3) / RENDER_DISTANCE;
 	float fog = max(depth - fogNear, 0.0);

 	color.a *= 1.0 - fog;
}